import React from 'react';
import updateArrowsIcon from 'resources/images/arrows_up.svg';
import StyledButton from 'components/StyledButton';
import useStyles from './styles';

type Props = {
    strings: object,
    onDownloadUpdate: () => {}
};

function NewUpdateAvailable({ strings, onDownloadUpdate }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.updateAvailableContainer}>
            <img
                className={classes.updateAvailableIcon}
                src={updateArrowsIcon}
                alt="Available icon"
            />
            <div className={classes.updateAvailableTitle}>
                {strings.welcome_new_app_version_available}
            </div>
            <div className={classes.updateAvailableSubtitle}>
                {strings.welcome_new_app_version_available_description}
            </div>
            <StyledButton
                variant="contained"
                btnSize="big"
                onClick={onDownloadUpdate}
            >
                {strings.welcome_download_app_update}
            </StyledButton>
        </div>
    );
}

export default NewUpdateAvailable;
